#include <p30fxxxx.h>
#include <reset.h>

/********************************************************************
* Function Name     : isWU
* Description       : Checks whether wake up from SLEEP 
*                     is due to MCLR or Interrupt or POR or BOR.
* Parameters        : None
* Return Value      : Returns 2 for MCLR, 1 for interrupt, 
*                     3 for POR,4 for BOR.
*********************************************************************/

char isWU(void)
{
   if( RCONbits.SLEEP)
   {
       if(RCONbits.EXTR)
       {
           return 2;        /* wakeup is due to MCLR */
       }
      
       if(RCONbits.POR)
       {
		   return 3;        /* wakeup is due to POR */
       } 
	
       if(RCONbits.BOR)
       {   
           return 4;         /* wakeup is due to BOR */
       }
       else
           return 1;             /* else, wakeup is due to interrupt. */
   }
  return 0;       
}
